// write_log.cpp: Implementierung der Klasse write_log.
//
//////////////////////////////////////////////////////////////////////

#include "write_log.h"

//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

write_log::write_log()
{

}

write_log::~write_log()
{

}

void write_log::mywrite(int log, char *buf)
{
	_write (log, buf, strlen (buf));
}

void write_log::write_idda_log(demodata* data, char* pathstr)
{
	char temp[1400];
	int i;
	int len;
	demodata_t* current;
	int log = _open (pathstr, _O_BINARY | _O_CREAT | _O_TRUNC | _O_WRONLY, _S_IWRITE);
	current = data->get_first ();
	for (;;) {
		if (current == 0) break;
/*		
		if (current->type == 111) {
			current = current->next;
			continue;
		}
*/
		strcpy (temp, "ID: ");
		_itoa (current->id, temp+strlen(temp), 10);
		strcat (temp, " TIME: ");
		_itoa (current->time, temp+strlen(temp), 10);
		strcat (temp, " FRAME: ");
		_itoa (current->frame, temp+strlen(temp), 10);
		strcat (temp, " ");
		switch (current->type) {
		case 0: // standard type
			strcat (temp, "STDT:  ");
			break;
		case 1: // frag
			strcat (temp, "FRAG: ");
			break;
		case 2: // client/server
			strcat (temp, "CLSV: ");
			break;
		case 3: // chat
			strcat (temp, "CHAT: ");
			break;
		case 4: // map filename
			strcat (temp, "MAPF: ");
			break;
		case 5: // player heartbeat
			strcat (temp, "PLYR: ");
			break;
		case 6: // map name
			strcat (temp, "MAPN: ");
			break;
		case 50: // stufftext
			strcat (temp, "STUF: ");
			break;
		case 100: // demo filename
			strcat (temp, "FILE: ");
			break;
		case 101: // demo size
			strcat (temp, "SIZE: ");
			break;
		case 102: // game type
			strcat (temp, "TYPE: ");
			break;
		case 111: // origin 
			strcat (temp, "ORIG: ");
			break;
		case 222: // origin 
			strcat (temp, "QUAD: ");
			break;
		default: // miscellaneous messages
			char temp[64];
			_itoa (current->type, temp, 10);
			strcat (temp, ":");
			for (i = 0; i < 6 - strlen (temp); i++) {
				strcat (temp, " ");
			}
			strcat (temp, temp);
			break;
		}
		if (current->type <= 2) {
			current->type = current->type;
		}
		switch (current->type) { // output current->value if necessary
		case 5: 
			strcat (temp, current->message);
			sprintf (temp+strlen(temp), " (id: %i)", current->vp_int[0]);
			break;
		case 111:
			sprintf (temp+strlen(temp), "%f %f %f (%i)",
				current->vp_float[0], current->vp_float[1], current->vp_float[2], current->vp_int[0]);
			break;
		case 222:
			sprintf (temp+strlen(temp), "%i", current->vp_int[0]);
			break;
		default:
			strcat (temp, current->message);
			break;
		}
		len = strlen (temp);
		if (temp[len-1] == '\n') {
			temp[len-1] = '\r';
			strcat (temp, "\n");
			len++;
		} else {
			strcat (temp, "\r\n");
			len+=2;
		}
		//		if ((current->type != 111) || (current->vp_int[0] == 5)) // DEV
		_write (log, temp, len);
		current = current->next;
	}		
	_close (log);
}

void write_log::write_console_log(demodata *data, char *pathstr)
{
	char temp[1400];
	int len;
	demodata_t* current;
	int log = _open (pathstr, _O_BINARY | _O_CREAT | _O_TRUNC | _O_WRONLY, _S_IWRITE);
	current = data->get_first ();
	for (;;) {
		if (current == 0) break;
		switch (current->type) {
		case 1: // frag
		case 2: // client/server
		case 3: // chat
			strcpy (temp, current->message);
			len = strlen (temp);
			if (temp[len-1] != '\n') {
				strcat (temp, "\r\n");
				len += 2;
			} else {
				if (temp[len-2] != '\r') {
					temp[len-1] = '\r';
					strcat (temp, "\n");
					len++;
				}
			}
			_write (log, temp, len);
			break;
		default: // miscellaneous messages
			break;
		}
		current = current->next;
	}		
	_close (log);
}

void write_log::write_chat_log(demodata *data, char *pathstr)
{
	char temp[1400];
	int len;
	demodata_t* current;
	int log = _open (pathstr, _O_BINARY | _O_CREAT | _O_TRUNC | _O_WRONLY, _S_IWRITE);
	current = data->get_first ();
	for (;;) {
		if (current == 0) break;
		switch (current->type) {
		case 3: // chat
			strcpy (temp, current->message);
			len = strlen (temp);
			if (temp[len-1] != '\n') {
				strcat (temp, "\r\n");
				len += 2;
			} else {
				if (temp[len-2] != '\r') {
					temp[len-1] = '\r';
					strcat (temp, "\n");
					len++;
				}
			}
			_write (log, temp, len);
			break;
		default: // miscellaneous messages
			break;
		}
		current = current->next;
	}		
	_close (log);
}

void write_log::write_console_log_html(demodata *data, char *pathstr)
{
	char temp[1400];
	int len;
	demodata_t* current;
	int log = _open (pathstr, _O_BINARY | _O_CREAT | _O_TRUNC | _O_WRONLY, _S_IWRITE);
	mywrite (log, "<html>\r\n");
	mywrite (log, "<body bgcolor=\"#000000\" text=\"#FFFFFF\">\r\n<p>\r\n");
	current = data->get_first ();
	for (;;) {
		if (current == 0) break;
		switch (current->type) {
		case 1:
		case 2:
		case 3:
			strcpy (temp, current->message);
			len = strlen (temp);
			if (len == 0) {
				current = current->next;
				continue;
			}
			break;
		}
		switch (current->type) {
		case 1: // frag
			_write (log, temp, len);
			mywrite (log, "<br>\r\n");
			break;
		case 2: // client/server
			mywrite (log, "<font color=\"#0000FF\">");
			_write (log, temp, len);
			mywrite (log, "</font><br>\r\n");
			break;
		case 3: // chat
			mywrite (log, "<font color=\"#FF0000\">");
			_write (log, temp, len);
			mywrite (log, "</font><br>\r\n");
			break;
		default: // miscellaneous messages
			break;
		}
		current = current->next;
	}		
	mywrite (log, "</p>\r\n</body>\r\n</html>\r\n");
	_close (log);
}

